#!/usr/bin/perl -w
#
# Check to see whether the current architecture is supported by
# mesasdk

# Determine OS type

my $os = `uname -s 2>/dev/null`;
chomp $os;

# Determine whether the arch is supported

my $supported = 'N';

if($os eq 'Linux') {

    # Linux -- use uname -m

    my $arch = `uname -m 2>/dev/null`;
    chomp $arch;

    if($arch eq 'x86_64') {
	$supported = 'Y';
    }
    elsif($arch eq 'i686') {
	$supported = 'Y';
    }

}
elsif($os eq 'Darwin') {

    # Darwin (OS X) -- use system_profiler

    my $hardware_data = `system_profiler SPHardwareDataType`;

    if($hardware_data =~ m/^\s*Model Identifier:\s*([A-Za-z]+)(\d+),(\d+)\s*$/m) {

	my $model_name = $1;
	my $model_major = $2;
	my $model_minor = $3;

	if($model_name eq 'MacPro' ||
	   $model_name eq 'MacBookAir' ||
	   $model_name eq 'Xserve' ||
	   ($model_name eq 'MacBookPro' && $model_major >= 2) ||
	   ($model_name eq 'MacBook' && $model_major >= 2) ||
	   ($model_name eq 'iMac' && $model_major >= 5) ||
	   ($model_name eq 'Macmini' && $model_major >= 2)) {
	    $supported = 'Y';
	}

    }

}

# Output the result

print "$supported\n";

exit 0;
